-- =============================================
-- PARTE 2: TABELAS DE PACOTES
-- =============================================

USE ravenaturismo_office;

-- PACOTES
CREATE TABLE pacotes (
    id INT PRIMARY KEY AUTO_INCREMENT,
    categoria_id INT NOT NULL,
    titulo VARCHAR(200) NOT NULL,
    slug VARCHAR(200) UNIQUE NOT NULL,
    subtitulo VARCHAR(300),
    descricao_curta TEXT,
    descricao_completa LONGTEXT,
    foto_capa VARCHAR(255),
    duracao VARCHAR(50),
    destino VARCHAR(100),
    ativo TINYINT(1) DEFAULT 1,
    destaque TINYINT(1) DEFAULT 0,
    visualizacoes INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (categoria_id) REFERENCES categorias(id) ON DELETE CASCADE,
    INDEX idx_categoria (categoria_id),
    INDEX idx_slug (slug),
    INDEX idx_ativo (ativo)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- PACOTE_INCLUSOS
CREATE TABLE pacote_inclusos (
    id INT PRIMARY KEY AUTO_INCREMENT,
    pacote_id INT NOT NULL,
    tipo ENUM('incluso', 'nao_incluso') NOT NULL,
    item TEXT NOT NULL,
    ordem INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (pacote_id) REFERENCES pacotes(id) ON DELETE CASCADE,
    INDEX idx_pacote_tipo (pacote_id, tipo)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- PACOTE_ROTEIRO
CREATE TABLE pacote_roteiro (
    id INT PRIMARY KEY AUTO_INCREMENT,
    pacote_id INT NOT NULL,
    dia INT NOT NULL,
    titulo VARCHAR(200),
    descricao TEXT NOT NULL,
    ordem INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (pacote_id) REFERENCES pacotes(id) ON DELETE CASCADE,
    INDEX idx_pacote (pacote_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- PACOTE_CHECKLIST
CREATE TABLE pacote_checklist (
    id INT PRIMARY KEY AUTO_INCREMENT,
    pacote_id INT NOT NULL,
    item VARCHAR(255) NOT NULL,
    categoria VARCHAR(50) DEFAULT 'Geral',
    ordem INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (pacote_id) REFERENCES pacotes(id) ON DELETE CASCADE,
    INDEX idx_pacote (pacote_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- PACOTE_VALORES
CREATE TABLE pacote_valores (
    id INT PRIMARY KEY AUTO_INCREMENT,
    pacote_id INT NOT NULL,
    moeda ENUM('BRL', 'USD', 'EUR') NOT NULL DEFAULT 'BRL',
    valor_unitario DECIMAL(10,2) NOT NULL,
    tipo_acomodacao VARCHAR(100) DEFAULT 'Standard',
    observacao TEXT,
    ativo TINYINT(1) DEFAULT 1,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (pacote_id) REFERENCES pacotes(id) ON DELETE CASCADE,
    INDEX idx_pacote (pacote_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- PACOTE_GALERIA
CREATE TABLE pacote_galeria (
    id INT PRIMARY KEY AUTO_INCREMENT,
    pacote_id INT NOT NULL,
    tipo ENUM('imagem', 'video') NOT NULL DEFAULT 'imagem',
    arquivo VARCHAR(255) NOT NULL,
    legenda VARCHAR(255),
    youtube_id VARCHAR(20),
    ordem INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (pacote_id) REFERENCES pacotes(id) ON DELETE CASCADE,
    INDEX idx_pacote_tipo (pacote_id, tipo)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

SELECT '✅ PARTE 2 OK - Tabelas de pacotes criadas!' AS status;