-- =============================================
-- PARTE 3: TABELAS DE ORÇAMENTOS
-- =============================================

USE ravenaturismo_office;

-- SOLICITACOES_ORCAMENTO
CREATE TABLE solicitacoes_orcamento (
    id INT PRIMARY KEY AUTO_INCREMENT,
    nome_completo VARCHAR(150) NOT NULL,
    email VARCHAR(150) NOT NULL,
    telefone VARCHAR(20) NOT NULL,
    whatsapp VARCHAR(20),
    pacote_id INT NULL,
    pacote_nome VARCHAR(200),
    destino_interesse VARCHAR(200),
    data_ida DATE NULL,
    data_volta DATE NULL,
    num_adultos INT DEFAULT 1,
    num_criancas INT DEFAULT 0,
    num_bebes INT DEFAULT 0,
    tipo_acomodacao VARCHAR(100),
    orcamento_estimado VARCHAR(50),
    observacoes TEXT,
    como_conheceu VARCHAR(100),
    origem_formulario VARCHAR(50) DEFAULT 'site',
    url_origem VARCHAR(255),
    status ENUM('novo', 'em_analise', 'proposta_enviada', 'fechado', 'perdido', 'cancelado') DEFAULT 'novo',
    prioridade ENUM('baixa', 'media', 'alta', 'urgente') DEFAULT 'media',
    responsavel_id INT NULL,
    enviado_n8n TINYINT(1) DEFAULT 0,
    data_envio_n8n TIMESTAMP NULL,
    webhook_response TEXT,
    ip_cliente VARCHAR(45),
    user_agent TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (pacote_id) REFERENCES pacotes(id) ON DELETE SET NULL,
    FOREIGN KEY (responsavel_id) REFERENCES usuarios(id) ON DELETE SET NULL,
    INDEX idx_status (status),
    INDEX idx_created (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- HISTORICO_ORCAMENTO
CREATE TABLE historico_orcamento (
    id INT PRIMARY KEY AUTO_INCREMENT,
    orcamento_id INT NOT NULL,
    usuario_id INT NULL,
    acao VARCHAR(100) NOT NULL,
    descricao TEXT,
    status_anterior VARCHAR(50),
    status_novo VARCHAR(50),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (orcamento_id) REFERENCES solicitacoes_orcamento(id) ON DELETE CASCADE,
    FOREIGN KEY (usuario_id) REFERENCES usuarios(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

SELECT '✅ PARTE 3 OK - Tabelas de orçamentos criadas!' AS status;