-- =============================================
-- PARTE 4: DADOS INICIAIS
-- =============================================

USE ravenaturismo_office;

-- Usuários (senha: Ravena@2025)
INSERT INTO usuarios (nome, email, senha, nivel, ativo) VALUES
('Administrador Ravena', 'admin@ravenaturismo.com.br', '$2y$10$7aWJEWs5Y8WGHgvPH.4uje3PXXqjPxQp7hvKy3k.zb9L7YxT0qE4G', 'admin', 1),
('Editor Ravena', 'editor@ravenaturismo.com.br', '$2y$10$7aWJEWs5Y8WGHgvPH.4uje3PXXqjPxQp7hvKy3k.zb9L7YxT0qE4G', 'editor', 1);

-- Categorias
INSERT INTO categorias (nome, slug, icone, descricao, ordem) VALUES
('Aéreo', 'aereo', '✈️', 'Pacotes com passagens aéreas', 1),
('Terrestre', 'terrestre', '🚌', 'Viagens terrestres', 2),
('Experiências', 'experiencias', '🎭', 'Experiências únicas', 3),
('Roteiros', 'roteiros', '🗺️', 'Roteiros personalizados', 4);

-- Banners
INSERT INTO banners (titulo, subtitulo, imagem, link, ordem, ativo) VALUES
('Descubra o Mundo', 'Experiências inesquecíveis', 'banner1.jpg', NULL, 1, 1),
('Pacotes 2025', 'Descontos incríveis', 'banner2.jpg', NULL, 2, 1);

-- Configurações
INSERT INTO configuracoes_sistema (chave, valor, descricao, tipo) VALUES
('n8n_webhook_url', '', 'URL webhook n8n', 'texto'),
('n8n_webhook_ativo', '0', 'Ativar n8n', 'boolean'),
('n8n_webhook_secret', '', 'Chave secreta', 'texto'),
('email_notificacao_orcamento', 'contato@ravenaturismo.com.br', 'Email notificações', 'texto');

-- Pacote Paris
INSERT INTO pacotes (categoria_id, titulo, slug, subtitulo, descricao_curta, descricao_completa, foto_capa, duracao, destino, ativo, destaque) VALUES
(1, 'Paris - Cidade Luz', 'paris-cidade-luz', 'Viagem inesquecível', 
'Conheça Paris! Torre Eiffel, Louvre, Champs-Élysées.', 
'7 dias em Paris com hotéis 4 estrelas e passeios guiados.',
'paris.jpg', '7 dias / 6 noites', 'Paris, França', 1, 1);

SET @p = LAST_INSERT_ID();

-- Inclusos
INSERT INTO pacote_inclusos (pacote_id, tipo, item, ordem) VALUES
(@p, 'incluso', 'Passagem aérea ida e volta', 1),
(@p, 'incluso', '6 noites hotel 4 estrelas', 2),
(@p, 'incluso', 'Café da manhã', 3),
(@p, 'incluso', 'Transfer aeroporto', 4),
(@p, 'nao_incluso', 'Visto consular', 1),
(@p, 'nao_incluso', 'Refeições extras', 2);

-- Roteiro
INSERT INTO pacote_roteiro (pacote_id, dia, titulo, descricao, ordem) VALUES
(@p, 1, 'Chegada', 'Chegada e transfer', 1),
(@p, 2, 'Paris Clássica', 'Torre Eiffel', 2),
(@p, 3, 'Louvre', 'Museu do Louvre', 3),
(@p, 4, 'Rio Sena', 'Passeio de barco', 4),
(@p, 5, 'Dia Livre', 'Explore Paris', 5),
(@p, 6, 'Despedida', 'Últimas compras', 6),
(@p, 7, 'Retorno', 'Volta ao Brasil', 7);

-- Checklist
INSERT INTO pacote_checklist (pacote_id, item, categoria, ordem) VALUES
(@p, 'Passaporte válido', 'Documentos', 1),
(@p, 'Visto', 'Documentos', 2),
(@p, 'Roupas de frio', 'Bagagem', 3),
(@p, 'Adaptador tomada', 'Eletrônicos', 4);

-- Valores
INSERT INTO pacote_valores (pacote_id, moeda, valor_unitario, tipo_acomodacao) VALUES
(@p, 'BRL', 12500.00, 'Duplo'),
(@p, 'USD', 2450.00, 'Duplo'),
(@p, 'EUR', 2280.00, 'Duplo');

-- Galeria
INSERT INTO pacote_galeria (pacote_id, tipo, arquivo, legenda, ordem) VALUES
(@p, 'imagem', 'paris1.jpg', 'Torre Eiffel', 1),
(@p, 'imagem', 'paris2.jpg', 'Louvre', 2),
(@p, 'imagem', 'paris3.jpg', 'Champs', 3);

SELECT '✅ PARTE 4 OK - Dados inseridos!' AS status;