<?php
require_once '../includes/config.php';
require_once '../includes/database.php';
require_once '../includes/auth.php';

checkAuth();

$db = getDB();

// Estatísticas
$stats = [
    'pacotes' => $db->query("SELECT COUNT(*) FROM pacotes WHERE ativo = 1")->fetchColumn(),
    'orcamentos_novos' => $db->query("SELECT COUNT(*) FROM solicitacoes_orcamento WHERE status = 'novo'")->fetchColumn(),
    'orcamentos_total' => $db->query("SELECT COUNT(*) FROM solicitacoes_orcamento")->fetchColumn(),
    'categorias' => $db->query("SELECT COUNT(*) FROM categorias WHERE ativo = 1")->fetchColumn()
];

// Últimos orçamentos
$stmt = $db->query("
    SELECT id, nome_completo, destino_interesse, created_at, status 
    FROM solicitacoes_orcamento 
    ORDER BY created_at DESC 
    LIMIT 5
");
$ultimos_orcamentos = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Ravena Turismo</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            background: #f3f4f6;
            color: #1f2937;
        }
        
        .header {
            background: white;
            padding: 1.5rem 2rem;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .header h1 {
            color: #1e40af;
            font-size: 1.5rem;
        }
        
        .user-info {
            display: flex;
            align-items: center;
            gap: 1rem;
        }
        
        .container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 2rem;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2rem;
        }
        
        .stat-card {
            background: white;
            padding: 1.5rem;
            border-radius: 12px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }
        
        .stat-card h3 {
            font-size: 0.875rem;
            color: #6b7280;
            margin-bottom: 0.5rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .stat-card .number {
            font-size: 2.5rem;
            font-weight: 700;
            color: #1e40af;
        }
        
        .menu-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2rem;
        }
        
        .menu-card {
            background: white;
            padding: 2rem;
            border-radius: 12px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            text-decoration: none;
            color: inherit;
            transition: all 0.2s;
        }
        
        .menu-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }
        
        .menu-card h3 {
            font-size: 1.25rem;
            margin-bottom: 0.5rem;
            color: #1e40af;
        }
        
        .section {
            background: white;
            padding: 2rem;
            border-radius: 12px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }
        
        .section h2 {
            margin-bottom: 1.5rem;
            color: #1f2937;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
        }
        
        th, td {
            padding: 1rem;
            text-align: left;
            border-bottom: 1px solid #e5e7eb;
        }
        
        th {
            background: #f9fafb;
            font-weight: 600;
            color: #6b7280;
            font-size: 0.875rem;
            text-transform: uppercase;
        }
        
        .badge {
            display: inline-block;
            padding: 0.25rem 0.75rem;
            border-radius: 999px;
            font-size: 0.75rem;
            font-weight: 600;
        }
        
        .badge-novo {
            background: #dbeafe;
            color: #1e40af;
        }
        
        .btn {
            display: inline-block;
            padding: 0.75rem 1.5rem;
            background: #1e40af;
            color: white;
            text-decoration: none;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.2s;
        }
        
        .btn:hover {
            background: #1e3a8a;
        }
        
        .btn-secondary {
            background: #6b7280;
        }
        
        .btn-secondary:hover {
            background: #4b5563;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>✈️ Ravena Turismo - Admin</h1>
        <div class="user-info">
            <span>👤 <?= htmlspecialchars($_SESSION['user_nome']) ?></span>
            <a href="logout.php" class="btn btn-secondary">Sair</a>
        </div>
    </div>
    
    <div class="container">
        <div class="stats-grid">
            <div class="stat-card">
                <h3>📦 Pacotes Ativos</h3>
                <div class="number"><?= $stats['pacotes'] ?></div>
            </div>
            <div class="stat-card">
                <h3>🔔 Orçamentos Novos</h3>
                <div class="number"><?= $stats['orcamentos_novos'] ?></div>
            </div>
            <div class="stat-card">
                <h3>📊 Total Orçamentos</h3>
                <div class="number"><?= $stats['orcamentos_total'] ?></div>
            </div>
            <div class="stat-card">
                <h3>🗂️ Categorias</h3>
                <div class="number"><?= $stats['categorias'] ?></div>
            </div>
        </div>
        
        <div class="menu-grid">
            <a href="configuracoes/" class="menu-card">
                <h3>⚙️ Configurações</h3>
                <p>Webhooks n8n, emails e sistema</p>
            </a>
            
            <a href="orcamentos/" class="menu-card">
                <h3>📋 Orçamentos</h3>
                <p>Gerenciar solicitações de orçamento</p>
            </a>
            
            <a href="#" class="menu-card">
                <h3>📦 Pacotes</h3>
                <p>Gerenciar pacotes de viagem</p>
            </a>
            
            <a href="#" class="menu-card">
                <h3>🎨 Banners</h3>
                <p>Gerenciar banners do site</p>
            </a>
        </div>
        
        <div class="section">
            <h2>📋 Últimos Orçamentos</h2>
            <?php if (count($ultimos_orcamentos) > 0): ?>
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Cliente</th>
                        <th>Destino</th>
                        <th>Data</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($ultimos_orcamentos as $orc): ?>
                    <tr>
                        <td>#<?= $orc['id'] ?></td>
                        <td><?= htmlspecialchars($orc['nome_completo']) ?></td>
                        <td><?= htmlspecialchars($orc['destino_interesse']) ?></td>
                        <td><?= date('d/m/Y H:i', strtotime($orc['created_at'])) ?></td>
                        <td><span class="badge badge-novo"><?= $orc['status'] ?></span></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <?php else: ?>
            <p>Nenhum orçamento ainda.</p>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>