<?php
require_once '../../includes/config.php';
require_once '../../includes/database.php';
require_once '../../includes/auth.php';

checkAuth();

$db = getDB();

// Buscar todos os orçamentos
$stmt = $db->query("
    SELECT o.*, p.titulo as pacote_titulo
    FROM solicitacoes_orcamento o
    LEFT JOIN pacotes p ON o.pacote_id = p.id
    ORDER BY o.created_at DESC
    LIMIT 50
");
$orcamentos = $stmt->fetchAll();

// Contar por status
$stmt = $db->query("
    SELECT status, COUNT(*) as total
    FROM solicitacoes_orcamento
    GROUP BY status
");
$stats = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Orçamentos - Admin Ravena</title>
    <link rel="stylesheet" href="../assets/css/admin.css">
</head>
<body>
    <div class="admin-container">
        <h1>📋 Solicitações de Orçamento</h1>
        
        <div class="stats-grid">
            <div class="stat-card">
                <h3>Novos</h3>
                <p class="stat-number"><?= $stats['novo'] ?? 0 ?></p>
            </div>
            <div class="stat-card">
                <h3>Em Análise</h3>
                <p class="stat-number"><?= $stats['em_analise'] ?? 0 ?></p>
            </div>
            <div class="stat-card">
                <h3>Fechados</h3>
                <p class="stat-number"><?= $stats['fechado'] ?? 0 ?></p>
            </div>
        </div>
        
        <table class="admin-table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Cliente</th>
                    <th>Destino</th>
                    <th>Data Ida</th>
                    <th>Status</th>
                    <th>n8n</th>
                    <th>Criado em</th>
                    <th>Ações</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($orcamentos as $orc): ?>
                <tr>
                    <td>#<?= $orc['id'] ?></td>
                    <td>
                        <strong><?= htmlspecialchars($orc['nome_completo']) ?></strong><br>
                        <small><?= htmlspecialchars($orc['email']) ?></small>
                    </td>
                    <td><?= htmlspecialchars($orc['destino_interesse']) ?></td>
                    <td><?= $orc['data_ida'] ? date('d/m/Y', strtotime($orc['data_ida'])) : '-' ?></td>
                    <td><span class="badge badge-<?= $orc['status'] ?>"><?= $orc['status'] ?></span></td>
                    <td><?= $orc['enviado_n8n'] ? '✅' : '❌' ?></td>
                    <td><?= date('d/m/Y H:i', strtotime($orc['created_at'])) ?></td>
                    <td>
                        <a href="detalhes.php?id=<?= $orc['id'] ?>">Ver</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</body>
</html>