<?php
/**
 * =============================================
 * RAVENA TURISMO - CONFIGURAÇÕES GERAIS
 * =============================================
 * URL Padrão: office.ravenaturismo.com.br
 * =============================================
 */

// ========== CONFIGURAÇÕES DO BANCO DE DADOS ==========
define('DB_HOST', 'localhost');
define('DB_NAME', 'ravenaturismo_office');
define('DB_USER', 'ravenaturismo_office');        // ⚠️ ALTERAR
define('DB_PASS', 'TS[,c?%SjkAW');          // ⚠️ ALTERAR
define('DB_CHARSET', 'utf8mb4');

// ========== URLS DO SISTEMA ==========
define('SITE_URL', 'https://office.ravenaturismo.com.br');
define('ADMIN_URL', SITE_URL . '/admin');
define('PUBLIC_URL', SITE_URL . '/public');
define('ASSETS_URL', PUBLIC_URL . '/assets');

// ========== CAMINHOS DE DIRETÓRIOS (WINDOWS) ==========
define('ROOT_PATH', dirname(__DIR__));
define('INCLUDES_PATH', ROOT_PATH . '/includes');
define('UPLOAD_PATH', ROOT_PATH . '/uploads');
define('UPLOAD_URL', SITE_URL . '/uploads');

// Subpastas de upload
define('UPLOAD_PACOTES_CAPAS', UPLOAD_PATH . '/pacotes/capas');
define('UPLOAD_PACOTES_GALERIA', UPLOAD_PATH . '/pacotes/galeria');
define('UPLOAD_BANNERS', UPLOAD_PATH . '/banners');

// URLs públicas dos uploads
define('UPLOAD_PACOTES_CAPAS_URL', UPLOAD_URL . '/pacotes/capas');
define('UPLOAD_PACOTES_GALERIA_URL', UPLOAD_URL . '/pacotes/galeria');
define('UPLOAD_BANNERS_URL', UPLOAD_URL . '/banners');

// ========== CONFIGURAÇÕES DE UPLOAD ==========
define('MAX_FILE_SIZE', 5 * 1024 * 1024);  // 5MB
define('ALLOWED_IMAGE_TYPES', ['image/jpeg', 'image/jpg', 'image/png', 'image/webp', 'image/gif']);
define('ALLOWED_VIDEO_TYPES', ['video/mp4', 'video/webm', 'video/avi']);

// ========== CONFIGURAÇÕES GERAIS ==========
define('SITE_NAME', 'Ravena Turismo');
define('SITE_EMAIL', 'contato@ravenaturismo.com.br');
define('SITE_PHONE', '(XX) XXXXX-XXXX');  // ⚠️ ALTERAR
define('TIMEZONE', 'America/Sao_Paulo');

// ========== CONFIGURAÇÕES DE SESSÃO ==========
define('SESSION_LIFETIME', 7200);  // 2 horas
define('SESSION_NAME', 'RAVENA_SESSION');

// ========== PAGINAÇÃO ==========
define('ITEMS_PER_PAGE', 12);
define('ADMIN_ITEMS_PER_PAGE', 20);

// ========== AMBIENTE ==========
define('ENVIRONMENT', 'development');  // development | production

// ========== ERROR REPORTING ==========
if (ENVIRONMENT === 'development') {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
} else {
    error_reporting(0);
    ini_set('display_errors', 0);
    ini_set('log_errors', 1);
    ini_set('error_log', ROOT_PATH . '/logs/php_errors.log');
}

// ========== TIMEZONE ==========
date_default_timezone_set(TIMEZONE);

// ========== INICIAR SESSÃO ==========
if (session_status() === PHP_SESSION_NONE) {
    ini_set('session.cookie_lifetime', SESSION_LIFETIME);
    ini_set('session.gc_maxlifetime', SESSION_LIFETIME);
    session_name(SESSION_NAME);
    session_start();
}

// ========== AUTOLOAD ==========
spl_autoload_register(function ($class) {
    $file = INCLUDES_PATH . '/classes/' . $class . '.php';
    if (file_exists($file)) {
        require_once $file;
    }
});

// ========== INCLUDES ==========
require_once INCLUDES_PATH . '/functions.php';
require_once INCLUDES_PATH . '/database.php';

// ========== HEADERS DE SEGURANÇA ==========
header('X-Content-Type-Options: nosniff');
header('X-Frame-Options: SAMEORIGIN');
header('X-XSS-Protection: 1; mode=block');

// Não permitir cache de páginas admin
if (strpos($_SERVER['REQUEST_URI'], '/admin/') !== false) {
    header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
    header('Pragma: no-cache');
    header('Expires: 0');
}
?>