<?php
require_once '../../includes/config.php';
require_once '../../includes/database.php';
require_once '../../includes/auth.php';

checkAuth();

$db = getDB();
$mensagem = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $configs = $_POST['config'];
    foreach ($configs as $chave => $valor) {
        $stmt = $db->prepare("UPDATE configuracoes_sistema SET valor = ? WHERE chave = ?");
        $stmt->execute([$valor, $chave]);
    }
    $mensagem = "Configurações salvas!";
}

$stmt = $db->query("SELECT chave, valor FROM configuracoes_sistema");
$configs = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Configurações - Ravena</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; margin: 0; padding: 20px; background: #f3f4f6; }
        .container { max-width: 1000px; margin: 0 auto; }
        .header { background: white; padding: 2rem; border-radius: 12px; margin-bottom: 2rem; }
        .header h1 { color: #1e40af; margin: 0; }
        .form-group { margin-bottom: 1.5rem; }
        .form-group label { display: block; font-weight: 600; margin-bottom: 0.5rem; }
        .form-group input { width: 100%; padding: 0.75rem; border: 1px solid #d1d5db; border-radius: 8px; }
        .btn { padding: 0.75rem 1.5rem; background: #1e40af; color: white; border: none; border-radius: 8px; cursor: pointer; }
        .alert { padding: 1rem; background: #d1fae5; color: #065f46; border-radius: 8px; margin-bottom: 1rem; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>⚙️ Configurações</h1>
            <p><a href="../index.php">← Voltar</a></p>
        </div>
        
        <?php if ($mensagem): ?>
        <div class="alert"><?= $mensagem ?></div>
        <?php endif; ?>
        
        <form method="POST" style="background: white; padding: 2rem; border-radius: 12px;">
            <h2>🔗 Webhook n8n</h2>
            
            <div class="form-group">
                <label>URL do Webhook</label>
                <input type="url" name="config[n8n_webhook_url]" value="<?= htmlspecialchars($configs['n8n_webhook_url'] ?? '') ?>">
            </div>
            
            <div class="form-group">
                <label>
                    <input type="checkbox" name="config[n8n_webhook_ativo]" value="1" <?= ($configs['n8n_webhook_ativo'] ?? '0') == '1' ? 'checked' : '' ?>>
                    Ativar envio automático
                </label>
            </div>
            
            <button type="submit" class="btn">💾 Salvar</button>
        </form>
    </div>
</body>
</html>