<?php
require_once 'includes/config.php';
require_once 'includes/database.php';

try {
    $db = getDB();
    echo "<h1 style='color: green;'>✅ Conexão OK!</h1>";
    
    echo "<h2>📊 Banco: ravenaturismo_office</h2>";
    
    // Testar tabelas
    $stmt = $db->query("SHOW TABLES");
    $tabelas = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    echo "<h3>Tabelas criadas (" . count($tabelas) . "):</h3>";
    echo "<ul>";
    foreach ($tabelas as $tabela) {
        echo "<li>✅ $tabela</li>";
    }
    echo "</ul>";
    
    // Testar dados
    $stmt = $db->query("SELECT COUNT(*) as total FROM categorias");
    $result = $stmt->fetch();
    echo "<p><strong>Categorias:</strong> {$result['total']}</p>";
    
    $stmt = $db->query("SELECT COUNT(*) as total FROM usuarios");
    $result = $stmt->fetch();
    echo "<p><strong>Usuários:</strong> {$result['total']}</p>";
    
    $stmt = $db->query("SELECT COUNT(*) as total FROM pacotes");
    $result = $stmt->fetch();
    echo "<p><strong>Pacotes:</strong> {$result['total']}</p>";
    
    echo "<hr>";
    echo "<h2 style='color: green;'>🎉 SISTEMA PRONTO!</h2>";
    echo "<p><strong>Login Admin:</strong> admin@ravenaturismo.com.br</p>";
    echo "<p><strong>Senha:</strong> Ravena@2025</p>";
    echo "<p><a href='admin/configuracoes/'>Ir para Configurações</a></p>";
    
    echo "<hr>";
    echo "<p style='color: red;'><strong>⚠️ DELETE ESTE ARQUIVO após o teste!</strong></p>";
    
} catch (Exception $e) {
    echo "<h1 style='color: red;'>❌ Erro</h1>";
    echo "<p>" . $e->getMessage() . "</p>";
    
    echo "<h3>Verifique:</h3>";
    echo "<ul>";
    echo "<li>Credenciais do banco em config.php</li>";
    echo "<li>Se o banco 'ravenaturismo_office' existe</li>";
    echo "<li>Se executou o SQL no phpMyAdmin</li>";
    echo "</ul>";
}
?>
```

---

# ✅ CHECKLIST FINAL

## **Execute nesta ordem:**

### **1️⃣ phpMyAdmin:**
- Cole o SQL `database_ravena.sql` completo
- Execute
- ✅ Deve mostrar: "Banco instalado com sucesso!"

### **2️⃣ Crie os arquivos:**
```
includes/config.php       (✅ COM SEUS DADOS)
includes/database.php
includes/functions.php
includes/auth.php
teste-conexao.php